<?php
$this->load->view("top_application");
$cart = $this->cart->contents();
$discount_amount = $this->session->userdata('discount_amount');
?>
<section class="checkout_page">
  <div class="container">
    <div class="row">
      <div class="col-lg-9 col-md-9 col-sm-8  col-xs-12">
        <div class="cart_left">
          <h1>Checkout</h1>
          <div class="panel-group checkout-steps" id="accordion">
            <!-- checkout-step-1  -->
            <section class="panel panel-default checkout-step-01">
              <h4 class="checkout_title">
                <a data-toggle="collapse"><span>1</span>Login or Signup <span class="pull-right"><i class="fa fa-check-square"></i></span></a>
              </h4>
            </section>

            <!-- checkout-step-02  -->
            <section class="panel panel-default checkout-step-02">
              <h4 class="checkout_title"><a data-toggle="collapse" href="javascript:void(0);"><span>2</span>Delivery Address <span class="pull-right"><i class="fa fa-check-square"></i></span></a></h4>
            </section>

            <!-- checkout-step-03  -->
            <div class="panel panel-default checkout-step-03">
              <h4 class="checkout_title">
                <a data-toggle="collapse" class="collapsed" data-parent="#accordion" href="javascript:void(0);">
                  <span>3</span>Order Summary</a>
              </h4>
              <div id="collapseThree" class="panel-collapse collapse in">
                <div class="panel-body">
                  <?php
                  echo form_open('cart/make_payment', 'name="cart_frm" id="cart_frm" ');
                  echo error_message();
                  echo validation_message();
                  ?>
                  <div class="summary">
                    <p class="summary_p">Order confirmation email will be sent to <a href="javascript:void()"><?php echo $this->session->userdata('username'); ?></a></p>

                    <table>
                      <thead>
                        <tr>
                          <th>Product</th>
                          <th class="text-left">Unit Price </th>
                          <th class="text-center" style="width: 175px;">QTY</th>
                          <th class="text-center">Total</th>
                          <th class="text-center">Remove</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        $totalAmount = $origAmount = $discountAmt = 0;
                        $i = 1;
                        // trace($cart);
                        foreach ($cart as $items) {
                          //trace($items);
                          $sizeName = $this->config->item('sizeName');
                          $link = ($this->session->userdata('user_id') > 0) ? 'href="' . site_url() . 'cart/add_to_wishlist/' . $items['pid'] . '"' : 'href="#" data-toggle="modal" data-target="#log-modal"';
                          $pprice = ($items['discount_price'] > 0) ? $items['discount_price'] : $items['product_price'];
                          $totalAmount += $pprice * $items['qty'];
                          $origAmount += $pprice * $items['qty'];
                          $discountAmt += ($items['product_price'] - $items['discount_price']) * $items['qty'];
                          if (!is_array($items['options']['Size'])) {
                            $color_name = get_db_field_value("wps_colors", "color_name", "WHERE color_id = '" . $items['options']['Color'] . "'");
                            $size_name = get_db_field_value("wps_sizes", "size_name", "WHERE size_id = '" . $items['options']['Size'] . "'");
                          } else {
                            $size_name = 'Custom';
                            $color_name = 'As Shown';
                          }
                          //trace($color_name);
                          $url = $this->db->query("SELECT friendly_url FROM wps_products WHERE products_id = '" . $items['pid'] . "'")->row_array();
                          ?>
                          <tr>
                            <td data-label="PRODUCT">
                              <div class="cart_image">
                                <a href="<?php echo site_url($url['friendly_url']); ?>"><img src="<?php echo get_image('product_images', $items['img'], '65', '90', 'R', $url['friendly_url']); ?>"></a>
                              </div>
                              <div class="cart_info">
                                <a href="<?php echo site_url($url['friendly_url']); ?>"><?php echo $items['origname']; ?></a>
                               
                                  <strong>Code</strong>: <?php echo $items['code']; ?><br />
                                  <strong>Color</strong>: <?php echo $color_name; ?> &nbsp; &nbsp;
                                  <span class="custom_size"><strong>Size</strong>: <span class="custom"><?php echo $size_name; ?></span>
                                    <?php
                                    if (is_array($items['options']['Size'])) {
                                      ?>
                                      <div class="custom-hover">
                                        <?php
                                        foreach ($sizeName as $key => $vals) {
                                          ?>
                                          <p><strong><?php echo $vals; ?>: </strong><?php echo $items['options']['Size'][$key]; ?> CM</p>
                                          <?php
                                        }
                                        ?>
                                      </div>
                                      <?php
                                    }
                                    ?>
                                  </span>
                               
                              </div>
                            </td>
                            <td class="text-center" data-label="UNIT PRICE">
                              <div class="price">
                                <?php echo display_price($pprice); ?>
                              </div>
                            </td>

                            <td class="text-center" data-label="QTY">
                              <div class="details_qty">
                                <input type="button" value="" class="minus" onclick="return incDnc(2, <?php echo $i; ?>, <?php echo $items['availableqty']; ?>);" />
                                <input type="text" readonly="readonly" name="<?php echo $i; ?>[qty]" id="qty_<?php echo $i; ?>" value="<?php echo $items['qty']; ?>" class="qty qty_value" maxlength="10">
                                <input type="button" value="" class="plus" onclick="return incDnc(1, <?php echo $i; ?>, <?php echo $items['availableqty']; ?>);" />
                                <input type="hidden" name="<?php echo $i; ?>[rowid]" id='cart_rowid_<?php echo $i; ?>' value="<?php echo $items['rowid']; ?>" />
                              </div>
                            </td>
                            <td class="text-center" data-label="TOTAL">
                              <div class="price">
                                <?php echo display_price($pprice * $items['qty']); ?>
                              </div>    
                            </td>
                            <td class="text-center" data-label="REMOVE">
                              <a class="cart_remove" href="<?php echo site_url(); ?>cart/remove_item/<?php echo $items['rowid']; ?>" title="remove"><i class="fa fa-remove"></i></a>
                            </td>
                          </tr>
                          <?php
                        }
                        ?>

                      </tbody>
                    </table>
                    <a class="continue" href="<?php echo site_url(); ?>cart/make_payment" title="Continue">Continue</a>
                  </div>
                  <?php echo form_close(); ?>
                </div>
              </div>
            </div>

            <!-- checkout-step-04  -->
            <div class="panel panel-default checkout-step-04">
              <h4 class="checkout_title"><a data-toggle="collapse" class="collapsed"><span>4</span>Payment Options</a></h4>
            </div>
            <!-- checkout-step-04  -->

          </div>
          <!-- /.checkout-steps -->
        </div>
      </div>
      <div class="col-lg-3 col-md-3 col-sm-4  col-xs-12">
        <div class="left_title">Cart Details</div>
        <div class="cart_right">
          <table class="table table-totals">
            <tbody>
              <tr>
                <td>Price (items)</td>
                <td>&#8377 <?php echo $totalAmount; ?></td>
              </tr>
              <?php
              if ($discount_amount > 0) {
                ?>
                <tr>
                  <td>Coupon discount</td>
                  <td>&#8377 <?= $discount_amount; ?></td>
                </tr>
                <tr>
                  <td>Total</td>
                  <td>&#8377 <?php echo ($totalAmount - $discount_amount); ?></td>
                </tr>
              </tbody>
              <?php
            } else {
              ?>
              <tr>
                <td>Delivery charges</td>
                <td class="free">Free</td>
              </tr>
              <tfoot>
                <tr>
                  <td>Total Amount</td>
                  <td>&#8377 <?php echo $totalAmount; ?></td>
                </tr>
              </tfoot>
              <?php
            }
            ?>
          </table>
          <p class="safe_info"><i class="fa fa-shield"></i> Safe and Secure Payments. Easy returns. 100% Authentic products.</p>
        </div>
      </div>
    </div>
  </div>    
</section>
<script src="<?php echo site_url(); ?>assets/developers/js/common.js"></script> 
<?php $this->load->view("bottom_application"); ?>